#!/bin/bash

PROGRAM="calculator"


#missing args
echo Calling calculator with NO arguments 
echo Expecting MISSING ARGUMENTS
echo `./$PROGRAM `
echo Calling calculator with arguments 1
echo Expecting MISSING ARGUMENTS
echo `./$PROGRAM 1`
echo Calling calculator with arguments 1 +
echo Expecting MISSING ARGUMENTS
echo `./$PROGRAM 1 + `
echo Calling calculator with arguments + 1
echo Expecting MISSING ARGUMENTS
echo `./$PROGRAM + 1`
echo Calling calculator with arguments 1 + 1 1
echo Expecting TOO MANY ARGUMENTS
echo `./$PROGRAM 1 + 1 1`
	#invalid inputs
echo Calling calculator with arguments a + 1 
echo Expecting SYNTAX ERROR
echo `./$PROGRAM a + 1`
echo Calling calculator with arguments 1 + a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 + a`
echo Calling calculator with arguments 1 + 1a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 + 1a`
echo Calling calculator with arguments 1a + 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1a + 1`
echo Calling calculator with arguments a + a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM a + a`
echo Calling calculator with arguments a a a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM a a a`
echo Calling calculator with arguments a +a a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM a +a a`
echo Calling calculator with arguments a +/ a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM a +/ a`


echo Calling calculator with arguments -1a + 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM -1a + 1`
echo Calling calculator with arguments 1 + -1a
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 + -1a `
echo Calling calculator with arguments 5-5 + 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 5-5 + 1`
echo Calling calculator with arguments -0.569 + 13-.46
echo Expecting SYNTAX ERROR
echo `./$PROGRAM -0.569 + 13-.46`
	#invalid operator
echo Calling calculator with arguments 1 ++ 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 ++ 1`
echo Calling calculator with arguments 1 -/ 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 -/ 1`
echo Calling calculator with arguments 1 1 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1 1 1`
echo Calling calculator with arguments 1.1.1 + 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM 1.1.1 + 1`
echo Calling calculator with arguments ..1 + 1
echo Expecting SYNTAX ERROR
echo `./$PROGRAM ..1 + 1`
	#Math errors
echo Calling calculator with arguments 1  / 0
echo Expecting MATH ERROR
echo `./$PROGRAM 1  / 0`
echo Calling calculator with arguments 1 % 0
echo Expecting MATH ERROR
echo `./$PROGRAM 1 % 0`
echo Calling calculator with arguments 1 % 0.5
echo Expecting MATH ERROR
echo `./$PROGRAM 1 % 0.5`
	#Successaful integer output
echo Calling calculator with arguments 1 + 1
echo Expecting 2
echo `./$PROGRAM 1 + 1`
echo Calling calculator with arguments 1 + 0
echo Expecting 1
echo `./$PROGRAM 1 + 0`
echo Calling calculator with arguments 2 - 1
echo Expecting 1
echo `./$PROGRAM 2 - 1`
echo Calling calculator with arguments -1 - -1
echo Expecting 0 
echo `./$PROGRAM -1 - -1`
echo Calling calculator with arguments 1 + -1
echo Expecting 0 
echo `./$PROGRAM 1 + -1`
echo Calling calculator with arguments 2 x 2
echo Expecting 4
echo `./$PROGRAM 2 x 2`
echo Calling calculator with arguments 2 x 0
echo Expecting 0 
echo `./$PROGRAM 2 x 0`
echo Calling calculator with arguments 10 / 5
echo Expecting 2
echo `./$PROGRAM 10 / 5`
echo Calling calculator with arguments 10 % 3
echo Expecting 1
echo `./$PROGRAM 10 % 3`
echo Calling calculator with arguments 5 / 10
echo Expecting 0.5
echo `./$PROGRAM 5 / 10`
echo Calling calculator with arguments 5 % 10
echo Expecting 5
echo `./$PROGRAM 5 % 10`
	#Successful float operations  
echo Calling calculator with arguments 1 + 0.5
echo Expecting  1.5
echo `./$PROGRAM 1 + 0.5`
echo Calling calculator with arguments 0.5 - 1
echo Expecting  -0.5
echo `./$PROGRAM 0.5 - 1`
echo Calling calculator with arguments 1 x 0.5
echo Expecting 0.5 
echo `./$PROGRAM 1 x 0.5`
echo Calling calculator with arguments 1 / 0.5
echo Expecting 2 
echo `./$PROGRAM 1 / 0.5`
echo Calling calculator with arguments 10 % 6.5
echo Expecting  4
echo `./$PROGRAM 10 % 6.5`
echo Calling calculator with arguments 1 + .5
echo Expecting  1.5
echo `./$PROGRAM 1 + .5`
echo Calling calculator with arguments .5 + .5
echo Expecting 1 
echo `./$PROGRAM .5 + .5`
   


